# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""capAlarm userdefined datapoint type, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4.  """


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import izot.resources.enumerations.alarm_type_t
import izot.resources.enumerations.priority_level_t


class capAlarm(izot.resources.base.Structure):
    """capAlarm userdefined datapoint type.  ."""

    def __init__(self):
        super().__init__(
            key=26,
            scope=4
        )

        self.__alarmType = izot.resources.enumerations.alarm_type_t.alarm_type_t(
        )
        self._register(('alarmType', self.__alarmType))

        self.__priority = izot.resources.enumerations.priority_level_t.priority_level_t(
        )
        self._register(('priority', self.__priority))

        self.__timeStamp = izot.resources.base.Scaled(
            size=8,
            signed=False,
            minimum=0,
            maximum=18446744073709551615,
        )
        self._register(('timeStamp', self.__timeStamp))

        self.__tsText = izot.resources.base.Array(
            [
                izot.resources.base.Scaled(
                    size=1,
                    signed=False,
                    minimum=0,
                    maximum=255
                ) for i in range(22)
            ]
        )
        self._register(('tsText', self.__tsText))

        self.__desscription = izot.resources.base.Array(
            [
                izot.resources.base.Scaled(
                    size=1,
                    signed=False,
                    minimum=0,
                    maximum=255
                ) for i in range(100)
            ]
        )
        self._register(('desscription', self.__desscription))
        self._original_name = 'UNVTcapAlarm'
        self._definition = userdefined.add(self)


    def __set_alarmType(self, v):
        self.__alarmType._value = v

    alarmType = property(
        lambda self: self.__alarmType._value,
        __set_alarmType,
        None,
        """."""
    )

    def __set_priority(self, v):
        self.__priority._value = v

    priority = property(
        lambda self: self.__priority._value,
        __set_priority,
        None,
        """."""
    )

    def __set_timeStamp(self, v):
        self.__timeStamp._value = v

    timeStamp = property(
        lambda self: self.__timeStamp._value,
        __set_timeStamp,
        None,
        """."""
    )

    def __set_tsText(self, v):
        self.__tsText._value = v

    tsText = property(
        lambda self: self.__tsText._value,
        __set_tsText,
        None,
        """."""
    )

    def __set_desscription(self, v):
        self.__desscription._value = v

    desscription = property(
        lambda self: self.__desscription._value,
        __set_desscription,
        None,
        """."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 132


if __name__ == '__main__':
    # unit test code.
    item = capAlarm()
    pass
